nelx=10;
nely=5;
delx=300e-6/nelx;
dely=30e-6/nely;
NoDispBC=2*(nely+1);
NoForceBC=1;
NodeNrs=(1:(nelx+1)*(nely+1))';
y=reshape(repmat((0:dely:dely*nely)',1,nelx+1),(nelx+1)*(nely+1),1);
x=reshape(repmat((0:delx:delx*nelx),nely+1,1),(nelx+1)*(nely+1),1);
%%
fid=fopen(['.\elem' num2str(nelx*nely) '.dat'],'wt');
fprintf(fid,'%s\n%s','Input data for 2D linear elastic continuum','Specify the number of elements');
fprintf(fid,'\n%d',nelx*nely);
fprintf(fid,'\n%s\n%s','Specify the element data as follows','Elem_number MaterialID Four node numbers in the CCW direction');
k=0;
for i=1:nelx
    for j=1:nely
        k=k+1;
        fprintf(fid,'\n%2i %2i %2i %2i %2i %2i',k,1,j+(i-1)*(nely+1),j+i*(nely+1),j+1+i*(nely+1),j+1+(i-1)*(nely+1));
    end
end
fprintf(fid,'\n%s\n%s','Specify material properties as per the IDs','MaterialID Youngs_Modulus Poisson_ratio Thickness');
fprintf(fid,'\n%2i %8i %5.2f %8i',1,155E9,.17,25e-6);
fprintf(fid,'\n%s','Specify the number of nodes');
fprintf(fid,'\n%7i',size(NodeNrs,1));
fprintf(fid,'\n %s\n%s','Specify the nodal coodinates','Node-number x-coordinate y-coordinate');
for i=1:size(NodeNrs,1)
    fprintf(fid,'\n%5i %10.8f %10.8f',NodeNrs(i,1),x(i,1),y(i,1));
end
fprintf(fid,'\n%s','Specify the number of displacement boundary conditions');
fprintf(fid,'\n%2i',NoDispBC);
fprintf(fid,'\n%s','Specify Node_number DoF Value');
% fprintf(fid,'\n%5i %2i %10.8f',NodeNrs(nely+1,1),1,0);
% fprintf(fid,'\n%5i %2i %10.8f',NodeNrs(nely+1,1),2,0);
%  fprintf(fid,'\n%5i %2i %10.8f',NodeNrs((nelx+1)*(nely+1),1),1,0);
%     fprintf(fid,'\n%5i %2i %10.8f',NodeNrs((nelx+1)*(nely+1),1),2,0);
for i=1:(nely+1)
    fprintf(fid,'\n%5i %2i %10.8f',NodeNrs(i,1),1,0);   
    fprintf(fid,'\n%5i %2i %10.8f',NodeNrs(i,1),2,0);   
end
fprintf(fid,'\n%s','Specify the number of force boundary conditions');
fprintf(fid,'\n%2i',NoForceBC);
fprintf(fid,'\n%s','Specify Node_number DoF Value');
% for i=1:(nelx-1)
   fprintf(fid,'\n%5i %2i %6.2f',(i+1)*(nely+1),2,500);
% end
fclose(fid);
clear all
clc